from enum import Enum


class UploadRequestMimeType(str, Enum):
    APPLICATIONJSON = "application/json"
    APPLICATIONMSWORD = "application/msword"
    APPLICATIONPDF = "application/pdf"
    APPLICATIONVND_MS_EXCEL = "application/vnd.ms-excel"
    APPLICATIONVND_MS_POWERPOINT = "application/vnd.ms-powerpoint"
    APPLICATIONVND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION = (
        "application/vnd.openxmlformats-officedocument.presentationml.presentation"
    )
    APPLICATIONVND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET = (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    )
    APPLICATIONVND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT = (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
    )
    APPLICATIONXML = "application/xml"
    APPLICATIONZIP = "application/zip"
    IMAGEGIF = "image/gif"
    IMAGEJPEG = "image/jpeg"
    IMAGEPNG = "image/png"
    IMAGESVGXML = "image/svg+xml"
    TEXTCSV = "text/csv"
    TEXTPLAIN = "text/plain"
    TEXTXML = "text/xml"
    VIDEOMP4 = "video/mp4"
    VIDEOOGG = "video/ogg"
    VIDEOQUICKTIME = "video/quicktime"

    def __str__(self) -> str:
        return str(self.value)
