from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Room")


@_attrs_define
class Room:
    """
    Attributes:
        id (Union[Unset, UUID]):
        room_type (Union[Unset, ItemType]):
        cubic_volume_in_m3 (Union[Unset, float]): Total volume in cubic meters.
        living_area_in_m2 (Union[Unset, float]): Living area in square meters.
        floor (Union[Unset, ItemType]):
        human_identifier (Union[Unset, str]): Text for a human to know which room it is. For example: Küche, or:
            Wohnzimmer, or: Kinderzimmer 1. Stock rechts, or: Waschküche, or: Weinkeller.
    """

    id: Union[Unset, UUID] = UNSET
    room_type: Union[Unset, "ItemType"] = UNSET
    cubic_volume_in_m3: Union[Unset, float] = UNSET
    living_area_in_m2: Union[Unset, float] = UNSET
    floor: Union[Unset, "ItemType"] = UNSET
    human_identifier: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        room_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.room_type, Unset):
            room_type = self.room_type.to_dict()

        cubic_volume_in_m3 = self.cubic_volume_in_m3

        living_area_in_m2 = self.living_area_in_m2

        floor: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.floor, Unset):
            floor = self.floor.to_dict()

        human_identifier = self.human_identifier

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if room_type is not UNSET:
            field_dict["roomType"] = room_type
        if cubic_volume_in_m3 is not UNSET:
            field_dict["cubicVolumeInM3"] = cubic_volume_in_m3
        if living_area_in_m2 is not UNSET:
            field_dict["livingAreaInM2"] = living_area_in_m2
        if floor is not UNSET:
            field_dict["floor"] = floor
        if human_identifier is not UNSET:
            field_dict["humanIdentifier"] = human_identifier

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _room_type = d.pop("roomType", UNSET)
        room_type: Union[Unset, ItemType]
        if isinstance(_room_type, Unset):
            room_type = UNSET
        else:
            room_type = ItemType.from_dict(_room_type)

        cubic_volume_in_m3 = d.pop("cubicVolumeInM3", UNSET)

        living_area_in_m2 = d.pop("livingAreaInM2", UNSET)

        _floor = d.pop("floor", UNSET)
        floor: Union[Unset, ItemType]
        if isinstance(_floor, Unset):
            floor = UNSET
        else:
            floor = ItemType.from_dict(_floor)

        human_identifier = d.pop("humanIdentifier", UNSET)

        room = cls(
            id=id,
            room_type=room_type,
            cubic_volume_in_m3=cubic_volume_in_m3,
            living_area_in_m2=living_area_in_m2,
            floor=floor,
            human_identifier=human_identifier,
        )

        room.additional_properties = d
        return room

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
