from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Plot")


@_attrs_define
class Plot:
    """
    Attributes:
        id (Union[Unset, UUID]):
        egrid (Union[Unset, str]): External Land Id, see https://www.cadastre.ch/de/manual-
            av/topic/realestate/egrid.html
        bfsnr (Union[Unset, str]): External city Id, see https://www.bfs.admin.ch/bfs/de/home/grundlagen/agvch.html
        external_plot_number (Union[Unset, str]): Plot number. Only clearly together with the BFSNR.
        plot_type (Union[Unset, ItemType]):
        area_in_m2 (Union[Unset, float]): Size in square metres.
        parent_id (Union[Unset, UUID]):
    """

    id: Union[Unset, UUID] = UNSET
    egrid: Union[Unset, str] = UNSET
    bfsnr: Union[Unset, str] = UNSET
    external_plot_number: Union[Unset, str] = UNSET
    plot_type: Union[Unset, "ItemType"] = UNSET
    area_in_m2: Union[Unset, float] = UNSET
    parent_id: Union[Unset, UUID] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        egrid = self.egrid

        bfsnr = self.bfsnr

        external_plot_number = self.external_plot_number

        plot_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.plot_type, Unset):
            plot_type = self.plot_type.to_dict()

        area_in_m2 = self.area_in_m2

        parent_id: Union[Unset, str] = UNSET
        if not isinstance(self.parent_id, Unset):
            parent_id = str(self.parent_id)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if egrid is not UNSET:
            field_dict["egrid"] = egrid
        if bfsnr is not UNSET:
            field_dict["bfsnr"] = bfsnr
        if external_plot_number is not UNSET:
            field_dict["externalPlotNumber"] = external_plot_number
        if plot_type is not UNSET:
            field_dict["plotType"] = plot_type
        if area_in_m2 is not UNSET:
            field_dict["areaInM2"] = area_in_m2
        if parent_id is not UNSET:
            field_dict["parentId"] = parent_id

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        egrid = d.pop("egrid", UNSET)

        bfsnr = d.pop("bfsnr", UNSET)

        external_plot_number = d.pop("externalPlotNumber", UNSET)

        _plot_type = d.pop("plotType", UNSET)
        plot_type: Union[Unset, ItemType]
        if isinstance(_plot_type, Unset):
            plot_type = UNSET
        else:
            plot_type = ItemType.from_dict(_plot_type)

        area_in_m2 = d.pop("areaInM2", UNSET)

        _parent_id = d.pop("parentId", UNSET)
        parent_id: Union[Unset, UUID]
        if isinstance(_parent_id, Unset):
            parent_id = UNSET
        else:
            parent_id = UUID(_parent_id)

        plot = cls(
            id=id,
            egrid=egrid,
            bfsnr=bfsnr,
            external_plot_number=external_plot_number,
            plot_type=plot_type,
            area_in_m2=area_in_m2,
            parent_id=parent_id,
        )

        plot.additional_properties = d
        return plot

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
