from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PaginationMetaData")


@_attrs_define
class PaginationMetaData:
    """
    Attributes:
        total_pages (float):
        total_count (float):
        result_count (float):
        next_page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.
        prev_page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.
        last_page_token (Union[Unset, str]):  Example: YmVmb3JlX2N1cnNvcjoyNDM.
    """

    total_pages: float
    total_count: float
    result_count: float
    next_page_token: Union[Unset, str] = UNSET
    prev_page_token: Union[Unset, str] = UNSET
    last_page_token: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        total_pages = self.total_pages

        total_count = self.total_count

        result_count = self.result_count

        next_page_token = self.next_page_token

        prev_page_token = self.prev_page_token

        last_page_token = self.last_page_token

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "totalPages": total_pages,
                "totalCount": total_count,
                "resultCount": result_count,
            }
        )
        if next_page_token is not UNSET:
            field_dict["nextPageToken"] = next_page_token
        if prev_page_token is not UNSET:
            field_dict["prevPageToken"] = prev_page_token
        if last_page_token is not UNSET:
            field_dict["lastPageToken"] = last_page_token

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        total_pages = d.pop("totalPages")

        total_count = d.pop("totalCount")

        result_count = d.pop("resultCount")

        next_page_token = d.pop("nextPageToken", UNSET)

        prev_page_token = d.pop("prevPageToken", UNSET)

        last_page_token = d.pop("lastPageToken", UNSET)

        pagination_meta_data = cls(
            total_pages=total_pages,
            total_count=total_count,
            result_count=result_count,
            next_page_token=next_page_token,
            prev_page_token=prev_page_token,
            last_page_token=last_page_token,
        )

        pagination_meta_data.additional_properties = d
        return pagination_meta_data

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
