from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Inventory")


@_attrs_define
class Inventory:
    """
    Attributes:
        id (Union[Unset, UUID]):
        inventory_type (Union[Unset, ItemType]):
    """

    id: Union[Unset, UUID] = UNSET
    inventory_type: Union[Unset, "ItemType"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        inventory_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.inventory_type, Unset):
            inventory_type = self.inventory_type.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if inventory_type is not UNSET:
            field_dict["inventoryType"] = inventory_type

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _inventory_type = d.pop("inventoryType", UNSET)
        inventory_type: Union[Unset, ItemType]
        if isinstance(_inventory_type, Unset):
            inventory_type = UNSET
        else:
            inventory_type = ItemType.from_dict(_inventory_type)

        inventory = cls(
            id=id,
            inventory_type=inventory_type,
        )

        inventory.additional_properties = d
        return inventory

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
