from collections.abc import Mapping
from typing import Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.history_object_id_status import HistoryObjectIdStatus
from ..types import UNSET, Unset

T = TypeVar("T", bound="HistoryObjectId")


@_attrs_define
class HistoryObjectId:
    """
    Attributes:
        object_id (Union[Unset, UUID]):  Example: 5c10e697-0bfb-43f4-9c4f-cabde817bc02.
        object_type (Union[Unset, str]):  Example: Building.
        status (Union[Unset, HistoryObjectIdStatus]):
    """

    object_id: Union[Unset, UUID] = UNSET
    object_type: Union[Unset, str] = UNSET
    status: Union[Unset, HistoryObjectIdStatus] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        object_id: Union[Unset, str] = UNSET
        if not isinstance(self.object_id, Unset):
            object_id = str(self.object_id)

        object_type = self.object_type

        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if object_id is not UNSET:
            field_dict["objectId"] = object_id
        if object_type is not UNSET:
            field_dict["objectType"] = object_type
        if status is not UNSET:
            field_dict["status"] = status

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        _object_id = d.pop("objectId", UNSET)
        object_id: Union[Unset, UUID]
        if isinstance(_object_id, Unset):
            object_id = UNSET
        else:
            object_id = UUID(_object_id)

        object_type = d.pop("objectType", UNSET)

        _status = d.pop("status", UNSET)
        status: Union[Unset, HistoryObjectIdStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = HistoryObjectIdStatus(_status)

        history_object_id = cls(
            object_id=object_id,
            object_type=object_type,
            status=status,
        )

        history_object_id.additional_properties = d
        return history_object_id

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
