from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.any_ import Any
    from ..models.pagination_meta_data import PaginationMetaData


T = TypeVar("T", bound="GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryResponse200")


@_attrs_define
class GetReodV1UserCtxIdBuildingBuildingIdApartmentApartmentIdRoomRoomIdInventoryResponse200:
    """
    Attributes:
        meta (PaginationMetaData):
        data (list['Any']):
    """

    meta: "PaginationMetaData"
    data: list["Any"]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.any_ import Any

        meta = self.meta.to_dict()

        data = []
        for data_item_data in self.data:
            data_item = data_item_data.to_dict()
            data.append(data_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "meta": meta,
                "data": data,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.any_ import Any
        from ..models.pagination_meta_data import PaginationMetaData

        d = dict(src_dict)
        meta = PaginationMetaData.from_dict(d.pop("meta"))

        data = []
        _data = d.pop("data")
        for data_item_data in _data:
            data_item = Any.from_dict(data_item_data)

            data.append(data_item)

        get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_response_200 = cls(
            meta=meta,
            data=data,
        )

        get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_response_200.additional_properties = d
        return get_reod_v1_user_ctx_id_building_building_id_apartment_apartment_id_room_room_id_inventory_response_200

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
