from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.energy_type import EnergyType


T = TypeVar("T", bound="EnergyConsumption")


@_attrs_define
class EnergyConsumption:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'energyConsumptionType': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'name': 'string', 'description': 'string', 'physicalUnit': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'kWh', 'name': 'Kilowattstunde', 'description':
            'Energiemasseinheit, Kilowattstunde (kWh).'}, 'ressourceChemicalSubstance': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht', 'description': 'Heizöl für
            den privatne Gebraucht, Extra Leicht'}, 'energyUnit': 'string'}, 'consumptionValue': 0}]

    Attributes:
        id (Union[Unset, UUID]):
        energy_consumption_type (Union[Unset, EnergyType]):
        consumption_value (Union[Unset, float]):
    """

    id: Union[Unset, UUID] = UNSET
    energy_consumption_type: Union[Unset, "EnergyType"] = UNSET
    consumption_value: Union[Unset, float] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        energy_consumption_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.energy_consumption_type, Unset):
            energy_consumption_type = self.energy_consumption_type.to_dict()

        consumption_value = self.consumption_value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if energy_consumption_type is not UNSET:
            field_dict["energyConsumptionType"] = energy_consumption_type
        if consumption_value is not UNSET:
            field_dict["consumptionValue"] = consumption_value

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.energy_type import EnergyType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _energy_consumption_type = d.pop("energyConsumptionType", UNSET)
        energy_consumption_type: Union[Unset, EnergyType]
        if isinstance(_energy_consumption_type, Unset):
            energy_consumption_type = UNSET
        else:
            energy_consumption_type = EnergyType.from_dict(_energy_consumption_type)

        consumption_value = d.pop("consumptionValue", UNSET)

        energy_consumption = cls(
            id=id,
            energy_consumption_type=energy_consumption_type,
            consumption_value=consumption_value,
        )

        energy_consumption.additional_properties = d
        return energy_consumption

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
