import datetime
from collections.abc import Mapping
from typing import Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.consent_consent_permission import ConsentConsentPermission
from ..models.consent_consent_scope import ConsentConsentScope
from ..types import UNSET, Unset

T = TypeVar("T", bound="Consent")


@_attrs_define
class Consent:
    """
    Attributes:
        consent_scope (ConsentConsentScope):  Example: USER_CONTEXT.
        consent_permission (ConsentConsentPermission):  Example: READ.
        id (Union[Unset, UUID]):  Example: 4de3c467-bc30-4640-8f0a-851b1c711a7e.
        user_id (Union[Unset, UUID]):  Example: 2c0c15c7-58f2-4d59-a345-fa162308de88.
        note (Union[Unset, str]):
        consent_valid_until_date (Union[Unset, datetime.datetime]):  Example: 2029-05-30T00:00:00.
    """

    consent_scope: ConsentConsentScope
    consent_permission: ConsentConsentPermission
    id: Union[Unset, UUID] = UNSET
    user_id: Union[Unset, UUID] = UNSET
    note: Union[Unset, str] = UNSET
    consent_valid_until_date: Union[Unset, datetime.datetime] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        consent_scope = self.consent_scope.value

        consent_permission = self.consent_permission.value

        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        user_id: Union[Unset, str] = UNSET
        if not isinstance(self.user_id, Unset):
            user_id = str(self.user_id)

        note = self.note

        consent_valid_until_date: Union[Unset, str] = UNSET
        if not isinstance(self.consent_valid_until_date, Unset):
            consent_valid_until_date = self.consent_valid_until_date.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "consentScope": consent_scope,
                "consentPermission": consent_permission,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if user_id is not UNSET:
            field_dict["userId"] = user_id
        if note is not UNSET:
            field_dict["note"] = note
        if consent_valid_until_date is not UNSET:
            field_dict["consentValidUntilDate"] = consent_valid_until_date

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        consent_scope = ConsentConsentScope(d.pop("consentScope"))

        consent_permission = ConsentConsentPermission(d.pop("consentPermission"))

        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _user_id = d.pop("userId", UNSET)
        user_id: Union[Unset, UUID]
        if isinstance(_user_id, Unset):
            user_id = UNSET
        else:
            user_id = UUID(_user_id)

        note = d.pop("note", UNSET)

        _consent_valid_until_date = d.pop("consentValidUntilDate", UNSET)
        consent_valid_until_date: Union[Unset, datetime.datetime]
        if isinstance(_consent_valid_until_date, Unset):
            consent_valid_until_date = UNSET
        else:
            consent_valid_until_date = isoparse(_consent_valid_until_date)

        consent = cls(
            consent_scope=consent_scope,
            consent_permission=consent_permission,
            id=id,
            user_id=user_id,
            note=note,
            consent_valid_until_date=consent_valid_until_date,
        )

        consent.additional_properties = d
        return consent

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
