import datetime
from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.attribute_type import AttributeType
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Attribute")


@_attrs_define
class Attribute:
    """
    Attributes:
        id (Union[Unset, UUID]):
        key (Union[Unset, str]): Optional. Used to distinguish between multiple uses of the same attribute. For example:
            One has an attribute: roomTemperature. This could be set 2x. Once with key = summer and once with key = winter.
        value (Union[Unset, str]): Value for data type: string.
        value_date (Union[Unset, datetime.date]):
        value_timestamp (Union[Unset, datetime.datetime]):
        value_boolean (Union[Unset, bool]):
        value_integer (Union[Unset, int]):
        value_number (Union[Unset, float]):
        value_item_type (Union[Unset, ItemType]):
        value_item_types (Union[Unset, list['ItemType']]):
        attribute_type (Union[Unset, AttributeType]):
    """

    id: Union[Unset, UUID] = UNSET
    key: Union[Unset, str] = UNSET
    value: Union[Unset, str] = UNSET
    value_date: Union[Unset, datetime.date] = UNSET
    value_timestamp: Union[Unset, datetime.datetime] = UNSET
    value_boolean: Union[Unset, bool] = UNSET
    value_integer: Union[Unset, int] = UNSET
    value_number: Union[Unset, float] = UNSET
    value_item_type: Union[Unset, "ItemType"] = UNSET
    value_item_types: Union[Unset, list["ItemType"]] = UNSET
    attribute_type: Union[Unset, "AttributeType"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        key = self.key

        value = self.value

        value_date: Union[Unset, str] = UNSET
        if not isinstance(self.value_date, Unset):
            value_date = self.value_date.isoformat()

        value_timestamp: Union[Unset, str] = UNSET
        if not isinstance(self.value_timestamp, Unset):
            value_timestamp = self.value_timestamp.isoformat()

        value_boolean = self.value_boolean

        value_integer = self.value_integer

        value_number = self.value_number

        value_item_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.value_item_type, Unset):
            value_item_type = self.value_item_type.to_dict()

        value_item_types: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.value_item_types, Unset):
            value_item_types = []
            for value_item_types_item_data in self.value_item_types:
                value_item_types_item = value_item_types_item_data.to_dict()
                value_item_types.append(value_item_types_item)

        attribute_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.attribute_type, Unset):
            attribute_type = self.attribute_type.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if key is not UNSET:
            field_dict["key"] = key
        if value is not UNSET:
            field_dict["value"] = value
        if value_date is not UNSET:
            field_dict["valueDate"] = value_date
        if value_timestamp is not UNSET:
            field_dict["valueTimestamp"] = value_timestamp
        if value_boolean is not UNSET:
            field_dict["valueBoolean"] = value_boolean
        if value_integer is not UNSET:
            field_dict["valueInteger"] = value_integer
        if value_number is not UNSET:
            field_dict["valueNumber"] = value_number
        if value_item_type is not UNSET:
            field_dict["valueItemType"] = value_item_type
        if value_item_types is not UNSET:
            field_dict["valueItemTypes"] = value_item_types
        if attribute_type is not UNSET:
            field_dict["attributeType"] = attribute_type

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.attribute_type import AttributeType
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        key = d.pop("key", UNSET)

        value = d.pop("value", UNSET)

        _value_date = d.pop("valueDate", UNSET)
        value_date: Union[Unset, datetime.date]
        if isinstance(_value_date, Unset):
            value_date = UNSET
        else:
            value_date = isoparse(_value_date).date()

        _value_timestamp = d.pop("valueTimestamp", UNSET)
        value_timestamp: Union[Unset, datetime.datetime]
        if isinstance(_value_timestamp, Unset):
            value_timestamp = UNSET
        else:
            value_timestamp = isoparse(_value_timestamp)

        value_boolean = d.pop("valueBoolean", UNSET)

        value_integer = d.pop("valueInteger", UNSET)

        value_number = d.pop("valueNumber", UNSET)

        _value_item_type = d.pop("valueItemType", UNSET)
        value_item_type: Union[Unset, ItemType]
        if isinstance(_value_item_type, Unset):
            value_item_type = UNSET
        else:
            value_item_type = ItemType.from_dict(_value_item_type)

        value_item_types = []
        _value_item_types = d.pop("valueItemTypes", UNSET)
        for value_item_types_item_data in _value_item_types or []:
            value_item_types_item = ItemType.from_dict(value_item_types_item_data)

            value_item_types.append(value_item_types_item)

        _attribute_type = d.pop("attributeType", UNSET)
        attribute_type: Union[Unset, AttributeType]
        if isinstance(_attribute_type, Unset):
            attribute_type = UNSET
        else:
            attribute_type = AttributeType.from_dict(_attribute_type)

        attribute = cls(
            id=id,
            key=key,
            value=value,
            value_date=value_date,
            value_timestamp=value_timestamp,
            value_boolean=value_boolean,
            value_integer=value_integer,
            value_number=value_number,
            value_item_type=value_item_type,
            value_item_types=value_item_types,
            attribute_type=attribute_type,
        )

        attribute.additional_properties = d
        return attribute

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
