from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Area")


@_attrs_define
class Area:
    """
    Attributes:
        id (Union[Unset, UUID]):
        area_in_m2 (Union[Unset, float]):
        area_type (Union[Unset, ItemType]):
        name (Union[Unset, str]): Designation of user, so that he knows which area it is.
    """

    id: Union[Unset, UUID] = UNSET
    area_in_m2: Union[Unset, float] = UNSET
    area_type: Union[Unset, "ItemType"] = UNSET
    name: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        area_in_m2 = self.area_in_m2

        area_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.area_type, Unset):
            area_type = self.area_type.to_dict()

        name = self.name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if area_in_m2 is not UNSET:
            field_dict["areaInM2"] = area_in_m2
        if area_type is not UNSET:
            field_dict["areaType"] = area_type
        if name is not UNSET:
            field_dict["name"] = name

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        area_in_m2 = d.pop("areaInM2", UNSET)

        _area_type = d.pop("areaType", UNSET)
        area_type: Union[Unset, ItemType]
        if isinstance(_area_type, Unset):
            area_type = UNSET
        else:
            area_type = ItemType.from_dict(_area_type)

        name = d.pop("name", UNSET)

        area = cls(
            id=id,
            area_in_m2=area_in_m2,
            area_type=area_type,
            name=name,
        )

        area.additional_properties = d
        return area

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
