from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.item_type import ItemType


T = TypeVar("T", bound="Address")


@_attrs_define
class Address:
    """
    Example:
        [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'addressType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'string', 'name': 'string', 'description': 'string'}, 'street': 'string', 'number': 'string',
            'additionalInformation': 'string', 'zipCode': 'string', 'zipPostfix': 'string', 'city': 'string', 'state':
            'string', 'iso2Country': 'CH'}]

    Attributes:
        id (Union[Unset, UUID]):
        address_type (Union[Unset, ItemType]):
        street (Union[Unset, str]):
        number (Union[Unset, str]):
        additional_information (Union[Unset, str]):
        zip_code (Union[Unset, str]):
        zip_postfix (Union[Unset, str]):
        city (Union[Unset, str]):
        state (Union[Unset, str]):
        iso_2_country (Union[Unset, str]): ISO Country-Code with 2 letters. Example: CH. See here:
            https://de.wikipedia.org/wiki/ISO-3166-1-Kodierliste (Alpha-2). Example: ['CH'].
    """

    id: Union[Unset, UUID] = UNSET
    address_type: Union[Unset, "ItemType"] = UNSET
    street: Union[Unset, str] = UNSET
    number: Union[Unset, str] = UNSET
    additional_information: Union[Unset, str] = UNSET
    zip_code: Union[Unset, str] = UNSET
    zip_postfix: Union[Unset, str] = UNSET
    city: Union[Unset, str] = UNSET
    state: Union[Unset, str] = UNSET
    iso_2_country: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id: Union[Unset, str] = UNSET
        if not isinstance(self.id, Unset):
            id = str(self.id)

        address_type: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.address_type, Unset):
            address_type = self.address_type.to_dict()

        street = self.street

        number = self.number

        additional_information = self.additional_information

        zip_code = self.zip_code

        zip_postfix = self.zip_postfix

        city = self.city

        state = self.state

        iso_2_country = self.iso_2_country

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if address_type is not UNSET:
            field_dict["addressType"] = address_type
        if street is not UNSET:
            field_dict["street"] = street
        if number is not UNSET:
            field_dict["number"] = number
        if additional_information is not UNSET:
            field_dict["additionalInformation"] = additional_information
        if zip_code is not UNSET:
            field_dict["zipCode"] = zip_code
        if zip_postfix is not UNSET:
            field_dict["zipPostfix"] = zip_postfix
        if city is not UNSET:
            field_dict["city"] = city
        if state is not UNSET:
            field_dict["state"] = state
        if iso_2_country is not UNSET:
            field_dict["iso2Country"] = iso_2_country

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.item_type import ItemType

        d = dict(src_dict)
        _id = d.pop("id", UNSET)
        id: Union[Unset, UUID]
        if isinstance(_id, Unset):
            id = UNSET
        else:
            id = UUID(_id)

        _address_type = d.pop("addressType", UNSET)
        address_type: Union[Unset, ItemType]
        if isinstance(_address_type, Unset):
            address_type = UNSET
        else:
            address_type = ItemType.from_dict(_address_type)

        street = d.pop("street", UNSET)

        number = d.pop("number", UNSET)

        additional_information = d.pop("additionalInformation", UNSET)

        zip_code = d.pop("zipCode", UNSET)

        zip_postfix = d.pop("zipPostfix", UNSET)

        city = d.pop("city", UNSET)

        state = d.pop("state", UNSET)

        iso_2_country = d.pop("iso2Country", UNSET)

        address = cls(
            id=id,
            address_type=address_type,
            street=street,
            number=number,
            additional_information=additional_information,
            zip_code=zip_code,
            zip_postfix=zip_postfix,
            city=city,
            state=state,
            iso_2_country=iso_2_country,
        )

        address.additional_properties = d
        return address

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
