from http import HTTPStatus
from typing import Any, Optional, Union, cast

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.attribute_type import AttributeType
from ...models.energy_type import EnergyType
from ...models.environment_impact_unit import EnvironmentImpactUnit
from ...models.format_type import FormatType
from ...models.get_reod_v1_dictionary_group_id_code_cast_to import GetReodV1DictionaryGroupIdCodeCastTo
from ...models.get_reod_v1_dictionary_group_id_code_identifier import GetReodV1DictionaryGroupIdCodeIdentifier
from ...models.get_reod_v1_dictionary_group_id_code_order_by import GetReodV1DictionaryGroupIdCodeOrderBy
from ...models.get_reod_v1_dictionary_group_id_code_response_200_item_type_0 import (
    GetReodV1DictionaryGroupIdCodeResponse200ItemType0,
)
from ...models.group_info import GroupInfo
from ...models.item_type import ItemType
from ...models.item_type_complex import ItemTypeComplex
from ...models.label_type import LabelType
from ...models.physical_unit import PhysicalUnit
from ...models.ressource_chemical_substance import RessourceChemicalSubstance
from ...types import UNSET, Response, Unset


def _get_kwargs(
    id_code: str,
    *,
    order_by: Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy] = UNSET,
    cast_to: Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo] = UNSET,
    identifier: GetReodV1DictionaryGroupIdCodeIdentifier,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    params: dict[str, Any] = {}

    json_order_by: Union[Unset, str] = UNSET
    if not isinstance(order_by, Unset):
        json_order_by = order_by.value

    params["orderBy"] = json_order_by

    json_cast_to: Union[Unset, str] = UNSET
    if not isinstance(cast_to, Unset):
        json_cast_to = cast_to.value

    params["castTo"] = json_cast_to

    json_identifier = identifier.value
    params["identifier"] = json_identifier

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/reod/v1/dictionary/group/{id_code}",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]
        ],
    ]
]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:

            def _parse_response_200_item(
                data: object,
            ) -> Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]:
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_0 = GetReodV1DictionaryGroupIdCodeResponse200ItemType0.from_dict(data)

                    return response_200_item_type_0
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_1 = ItemType.from_dict(data)

                    return response_200_item_type_1
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_2 = AttributeType.from_dict(data)

                    return response_200_item_type_2
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_3 = ItemTypeComplex.from_dict(data)

                    return response_200_item_type_3
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_4 = GroupInfo.from_dict(data)

                    return response_200_item_type_4
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_5 = LabelType.from_dict(data)

                    return response_200_item_type_5
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_6 = FormatType.from_dict(data)

                    return response_200_item_type_6
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_7 = EnergyType.from_dict(data)

                    return response_200_item_type_7
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_8 = PhysicalUnit.from_dict(data)

                    return response_200_item_type_8
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    response_200_item_type_9 = RessourceChemicalSubstance.from_dict(data)

                    return response_200_item_type_9
                except:  # noqa: E722
                    pass
                if not isinstance(data, dict):
                    raise TypeError()
                response_200_item_type_10 = EnvironmentImpactUnit.from_dict(data)

                return response_200_item_type_10

            response_200_item = _parse_response_200_item(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]
        ],
    ]
]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    id_code: str,
    *,
    client: Union[AuthenticatedClient, Client],
    order_by: Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy] = UNSET,
    cast_to: Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo] = UNSET,
    identifier: GetReodV1DictionaryGroupIdCodeIdentifier,
    user_language: Union[Unset, str] = UNSET,
) -> Response[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]
        ],
    ]
]:
    """Get Group Members

     Return an Array with all members of a specific group.

    Args:
        id_code (str):
        order_by (Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy]):
        cast_to (Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo]):
        identifier (GetReodV1DictionaryGroupIdCodeIdentifier):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, list[Union['AttributeType', 'EnergyType', 'EnvironmentImpactUnit', 'FormatType', 'GetReodV1DictionaryGroupIdCodeResponse200ItemType0', 'GroupInfo', 'ItemType', 'ItemTypeComplex', 'LabelType', 'PhysicalUnit', 'RessourceChemicalSubstance']]]]
    """

    kwargs = _get_kwargs(
        id_code=id_code,
        order_by=order_by,
        cast_to=cast_to,
        identifier=identifier,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    id_code: str,
    *,
    client: Union[AuthenticatedClient, Client],
    order_by: Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy] = UNSET,
    cast_to: Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo] = UNSET,
    identifier: GetReodV1DictionaryGroupIdCodeIdentifier,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]
        ],
    ]
]:
    """Get Group Members

     Return an Array with all members of a specific group.

    Args:
        id_code (str):
        order_by (Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy]):
        cast_to (Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo]):
        identifier (GetReodV1DictionaryGroupIdCodeIdentifier):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, list[Union['AttributeType', 'EnergyType', 'EnvironmentImpactUnit', 'FormatType', 'GetReodV1DictionaryGroupIdCodeResponse200ItemType0', 'GroupInfo', 'ItemType', 'ItemTypeComplex', 'LabelType', 'PhysicalUnit', 'RessourceChemicalSubstance']]]
    """

    return sync_detailed(
        id_code=id_code,
        client=client,
        order_by=order_by,
        cast_to=cast_to,
        identifier=identifier,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    id_code: str,
    *,
    client: Union[AuthenticatedClient, Client],
    order_by: Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy] = UNSET,
    cast_to: Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo] = UNSET,
    identifier: GetReodV1DictionaryGroupIdCodeIdentifier,
    user_language: Union[Unset, str] = UNSET,
) -> Response[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]
        ],
    ]
]:
    """Get Group Members

     Return an Array with all members of a specific group.

    Args:
        id_code (str):
        order_by (Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy]):
        cast_to (Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo]):
        identifier (GetReodV1DictionaryGroupIdCodeIdentifier):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, list[Union['AttributeType', 'EnergyType', 'EnvironmentImpactUnit', 'FormatType', 'GetReodV1DictionaryGroupIdCodeResponse200ItemType0', 'GroupInfo', 'ItemType', 'ItemTypeComplex', 'LabelType', 'PhysicalUnit', 'RessourceChemicalSubstance']]]]
    """

    kwargs = _get_kwargs(
        id_code=id_code,
        order_by=order_by,
        cast_to=cast_to,
        identifier=identifier,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    id_code: str,
    *,
    client: Union[AuthenticatedClient, Client],
    order_by: Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy] = UNSET,
    cast_to: Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo] = UNSET,
    identifier: GetReodV1DictionaryGroupIdCodeIdentifier,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[
    Union[
        Any,
        list[
            Union[
                "AttributeType",
                "EnergyType",
                "EnvironmentImpactUnit",
                "FormatType",
                "GetReodV1DictionaryGroupIdCodeResponse200ItemType0",
                "GroupInfo",
                "ItemType",
                "ItemTypeComplex",
                "LabelType",
                "PhysicalUnit",
                "RessourceChemicalSubstance",
            ]
        ],
    ]
]:
    """Get Group Members

     Return an Array with all members of a specific group.

    Args:
        id_code (str):
        order_by (Union[Unset, GetReodV1DictionaryGroupIdCodeOrderBy]):
        cast_to (Union[Unset, GetReodV1DictionaryGroupIdCodeCastTo]):
        identifier (GetReodV1DictionaryGroupIdCodeIdentifier):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, list[Union['AttributeType', 'EnergyType', 'EnvironmentImpactUnit', 'FormatType', 'GetReodV1DictionaryGroupIdCodeResponse200ItemType0', 'GroupInfo', 'ItemType', 'ItemTypeComplex', 'LabelType', 'PhysicalUnit', 'RessourceChemicalSubstance']]]
    """

    return (
        await asyncio_detailed(
            id_code=id_code,
            client=client,
            order_by=order_by,
            cast_to=cast_to,
            identifier=identifier,
            user_language=user_language,
        )
    ).parsed
