from http import HTTPStatus
from typing import Any, Optional, Union
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.fit_out_standard import FitOutStandard
from ...types import Response


def _get_kwargs(
    user_ctx_id: UUID,
    building_id: UUID,
    room_id: UUID,
    *,
    body: FitOutStandard,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}

    _kwargs: dict[str, Any] = {
        "method": "put",
        "url": f"/reod/v1/{user_ctx_id}/building/{building_id}/room/{room_id}/fit-out-standard",
    }

    _body = body.to_dict()

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Optional[Any]:
    if response.status_code == 200:
        return None
    if response.status_code == 400:
        return None
    if response.status_code == 401:
        return None
    if response.status_code == 403:
        return None
    if response.status_code == 404:
        return None
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Response[Any]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    room_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: FitOutStandard,
) -> Response[Any]:
    """Update FitOutStandard

     Update an exisiting FitOutStandard for Inventory.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        room_id (UUID):
        body (FitOutStandard):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        room_id=room_id,
        body=body,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


async def asyncio_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    room_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: FitOutStandard,
) -> Response[Any]:
    """Update FitOutStandard

     Update an exisiting FitOutStandard for Inventory.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        room_id (UUID):
        body (FitOutStandard):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        room_id=room_id,
        body=body,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)
