from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.attribute import Attribute
from ...types import Response


def _get_kwargs(
    user_ctx_id: UUID,
    building_id: UUID,
    *,
    body: list["Attribute"],
) -> dict[str, Any]:
    headers: dict[str, Any] = {}

    _kwargs: dict[str, Any] = {
        "method": "put",
        "url": f"/reod/v1/{user_ctx_id}/building/{building_id}/attribute",
    }

    _body = []
    for body_item_data in body:
        body_item = body_item_data.to_dict()
        _body.append(body_item)

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, list["Attribute"]]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = Attribute.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, list["Attribute"]]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: list["Attribute"],
) -> Response[Union[Any, list["Attribute"]]]:
    """Batch Attributes

     Batch operation: Defines all attributes in one action. Existing ones are updated if necessary. New
    ones are added. Those that no longer exist are deleted.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        body (list['Attribute']):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, list['Attribute']]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        body=body,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_ctx_id: UUID,
    building_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: list["Attribute"],
) -> Optional[Union[Any, list["Attribute"]]]:
    """Batch Attributes

     Batch operation: Defines all attributes in one action. Existing ones are updated if necessary. New
    ones are added. Those that no longer exist are deleted.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        body (list['Attribute']):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, list['Attribute']]
    """

    return sync_detailed(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        client=client,
        body=body,
    ).parsed


async def asyncio_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: list["Attribute"],
) -> Response[Union[Any, list["Attribute"]]]:
    """Batch Attributes

     Batch operation: Defines all attributes in one action. Existing ones are updated if necessary. New
    ones are added. Those that no longer exist are deleted.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        body (list['Attribute']):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, list['Attribute']]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        body=body,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_ctx_id: UUID,
    building_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: list["Attribute"],
) -> Optional[Union[Any, list["Attribute"]]]:
    """Batch Attributes

     Batch operation: Defines all attributes in one action. Existing ones are updated if necessary. New
    ones are added. Those that no longer exist are deleted.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        body (list['Attribute']):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, list['Attribute']]
    """

    return (
        await asyncio_detailed(
            user_ctx_id=user_ctx_id,
            building_id=building_id,
            client=client,
            body=body,
        )
    ).parsed
