from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.get_reod_v1_user_ctx_id_building_building_id_part_part_id_attribute_response_200 import (
    GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200,
)
from ...types import UNSET, Response, Unset


def _get_kwargs(
    user_ctx_id: UUID,
    building_id: UUID,
    part_id: UUID,
    *,
    size: Union[Unset, float] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    params: dict[str, Any] = {}

    params["size"] = size

    params["pageToken"] = page_token

    json_filter_by_group_id: Union[Unset, str] = UNSET
    if not isinstance(filter_by_group_id, Unset):
        json_filter_by_group_id = str(filter_by_group_id)
    params["filterByGroupId"] = json_filter_by_group_id

    params["filterByGroupCode"] = filter_by_group_code

    json_filter_by_type_id: Union[Unset, str] = UNSET
    if not isinstance(filter_by_type_id, Unset):
        json_filter_by_type_id = str(filter_by_type_id)
    params["filterByTypeId"] = json_filter_by_type_id

    params["filterByTypeCode"] = filter_by_type_code

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/reod/v1/{user_ctx_id}/building/{building_id}/part/{part_id}/attribute",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]:
    if response.status_code == 200:
        response_200 = GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200.from_dict(response.json())

        return response_200
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    part_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, float] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Response[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]:
    """Get Attributs

     Return an Array of Attributes (of a BuildingPart).

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        part_id (UUID):
        size (Union[Unset, float]):
        page_token (Union[Unset, str]):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        part_id=part_id,
        size=size,
        page_token=page_token,
        filter_by_group_id=filter_by_group_id,
        filter_by_group_code=filter_by_group_code,
        filter_by_type_id=filter_by_type_id,
        filter_by_type_code=filter_by_type_code,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_ctx_id: UUID,
    building_id: UUID,
    part_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, float] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]:
    """Get Attributs

     Return an Array of Attributes (of a BuildingPart).

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        part_id (UUID):
        size (Union[Unset, float]):
        page_token (Union[Unset, str]):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]
    """

    return sync_detailed(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        part_id=part_id,
        client=client,
        size=size,
        page_token=page_token,
        filter_by_group_id=filter_by_group_id,
        filter_by_group_code=filter_by_group_code,
        filter_by_type_id=filter_by_type_id,
        filter_by_type_code=filter_by_type_code,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    part_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, float] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Response[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]:
    """Get Attributs

     Return an Array of Attributes (of a BuildingPart).

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        part_id (UUID):
        size (Union[Unset, float]):
        page_token (Union[Unset, str]):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        part_id=part_id,
        size=size,
        page_token=page_token,
        filter_by_group_id=filter_by_group_id,
        filter_by_group_code=filter_by_group_code,
        filter_by_type_id=filter_by_type_id,
        filter_by_type_code=filter_by_type_code,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_ctx_id: UUID,
    building_id: UUID,
    part_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    size: Union[Unset, float] = UNSET,
    page_token: Union[Unset, str] = UNSET,
    filter_by_group_id: Union[Unset, UUID] = UNSET,
    filter_by_group_code: Union[Unset, str] = UNSET,
    filter_by_type_id: Union[Unset, UUID] = UNSET,
    filter_by_type_code: Union[Unset, str] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]]:
    """Get Attributs

     Return an Array of Attributes (of a BuildingPart).

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        part_id (UUID):
        size (Union[Unset, float]):
        page_token (Union[Unset, str]):
        filter_by_group_id (Union[Unset, UUID]):
        filter_by_group_code (Union[Unset, str]):
        filter_by_type_id (Union[Unset, UUID]):
        filter_by_type_code (Union[Unset, str]):
        user_language (Union[Unset, str]):  Example: ['deu'].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, GetReodV1UserCtxIdBuildingBuildingIdPartPartIdAttributeResponse200]
    """

    return (
        await asyncio_detailed(
            user_ctx_id=user_ctx_id,
            building_id=building_id,
            part_id=part_id,
            client=client,
            size=size,
            page_token=page_token,
            filter_by_group_id=filter_by_group_id,
            filter_by_group_code=filter_by_group_code,
            filter_by_type_id=filter_by_type_id,
            filter_by_type_code=filter_by_type_code,
            user_language=user_language,
        )
    ).parsed
