from http import HTTPStatus
from typing import Any, Optional, Union, cast
from uuid import UUID

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.energy_consumption import EnergyConsumption
from ...types import UNSET, Response, Unset


def _get_kwargs(
    user_ctx_id: UUID,
    building_id: UUID,
    apartment_id: UUID,
    room_id: UUID,
    *,
    body: EnergyConsumption,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": f"/reod/v1/{user_ctx_id}/building/{building_id}/apartment/{apartment_id}/room/{room_id}/energy-consumption",
    }

    _body = body.to_dict()

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, EnergyConsumption]]:
    if response.status_code == 201:
        response_201 = EnergyConsumption.from_dict(response.json())

        return response_201
    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    if response.status_code == 403:
        response_403 = cast(Any, None)
        return response_403
    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404
    if response.status_code == 409:
        response_409 = cast(Any, None)
        return response_409
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, EnergyConsumption]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    apartment_id: UUID,
    room_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyConsumption,
    user_language: Union[Unset, str] = UNSET,
) -> Response[Union[Any, EnergyConsumption]]:
    """Add EnergyConsumption

     Add the EnergyConsumption to the Inventory.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        apartment_id (UUID):
        room_id (UUID):
        user_language (Union[Unset, str]):  Example: ['eng'].
        body (EnergyConsumption):  Example: [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'energyConsumptionType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'name': 'string',
            'description': 'string', 'physicalUnit': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'kWh', 'name': 'Kilowattstunde', 'description': 'Energiemasseinheit,
            Kilowattstunde (kWh).'}, 'ressourceChemicalSubstance': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht',
            'description': 'Heizöl für den privatne Gebraucht, Extra Leicht'}, 'energyUnit':
            'string'}, 'consumptionValue': 0}].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, EnergyConsumption]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        apartment_id=apartment_id,
        room_id=room_id,
        body=body,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_ctx_id: UUID,
    building_id: UUID,
    apartment_id: UUID,
    room_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyConsumption,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, EnergyConsumption]]:
    """Add EnergyConsumption

     Add the EnergyConsumption to the Inventory.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        apartment_id (UUID):
        room_id (UUID):
        user_language (Union[Unset, str]):  Example: ['eng'].
        body (EnergyConsumption):  Example: [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'energyConsumptionType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'name': 'string',
            'description': 'string', 'physicalUnit': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'kWh', 'name': 'Kilowattstunde', 'description': 'Energiemasseinheit,
            Kilowattstunde (kWh).'}, 'ressourceChemicalSubstance': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht',
            'description': 'Heizöl für den privatne Gebraucht, Extra Leicht'}, 'energyUnit':
            'string'}, 'consumptionValue': 0}].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, EnergyConsumption]
    """

    return sync_detailed(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        apartment_id=apartment_id,
        room_id=room_id,
        client=client,
        body=body,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    user_ctx_id: UUID,
    building_id: UUID,
    apartment_id: UUID,
    room_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyConsumption,
    user_language: Union[Unset, str] = UNSET,
) -> Response[Union[Any, EnergyConsumption]]:
    """Add EnergyConsumption

     Add the EnergyConsumption to the Inventory.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        apartment_id (UUID):
        room_id (UUID):
        user_language (Union[Unset, str]):  Example: ['eng'].
        body (EnergyConsumption):  Example: [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'energyConsumptionType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'name': 'string',
            'description': 'string', 'physicalUnit': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'kWh', 'name': 'Kilowattstunde', 'description': 'Energiemasseinheit,
            Kilowattstunde (kWh).'}, 'ressourceChemicalSubstance': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht',
            'description': 'Heizöl für den privatne Gebraucht, Extra Leicht'}, 'energyUnit':
            'string'}, 'consumptionValue': 0}].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, EnergyConsumption]]
    """

    kwargs = _get_kwargs(
        user_ctx_id=user_ctx_id,
        building_id=building_id,
        apartment_id=apartment_id,
        room_id=room_id,
        body=body,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_ctx_id: UUID,
    building_id: UUID,
    apartment_id: UUID,
    room_id: UUID,
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyConsumption,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[Union[Any, EnergyConsumption]]:
    """Add EnergyConsumption

     Add the EnergyConsumption to the Inventory.

    Args:
        user_ctx_id (UUID):
        building_id (UUID):
        apartment_id (UUID):
        room_id (UUID):
        user_language (Union[Unset, str]):  Example: ['eng'].
        body (EnergyConsumption):  Example: [{'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'energyConsumptionType': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'name': 'string',
            'description': 'string', 'physicalUnit': {'id': '497f6eca-6276-4993-bfeb-53cbbbba6f08',
            'code': 'kWh', 'name': 'Kilowattstunde', 'description': 'Energiemasseinheit,
            Kilowattstunde (kWh).'}, 'ressourceChemicalSubstance': {'id':
            '497f6eca-6276-4993-bfeb-53cbbbba6f08', 'code': 'HEL', 'name': 'Heizöl extraleicht',
            'description': 'Heizöl für den privatne Gebraucht, Extra Leicht'}, 'energyUnit':
            'string'}, 'consumptionValue': 0}].

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, EnergyConsumption]
    """

    return (
        await asyncio_detailed(
            user_ctx_id=user_ctx_id,
            building_id=building_id,
            apartment_id=apartment_id,
            room_id=room_id,
            client=client,
            body=body,
            user_language=user_language,
        )
    ).parsed
