import os

from dotenv import load_dotenv

load_dotenv()

from authorization_code_client import authorization_code_flow

auth_response = authorization_code_flow()

from reod.reod_client import AuthenticatedClient

BASE_URL = os.getenv('BASE_URL')
with AuthenticatedClient(
        base_url=BASE_URL,
        token=auth_response.access_token
) as client:
    from reod.reod_client.models import ListUserContextResponse200, UserContext
    from reod.reod_client.api.user_context import list_user_context
    from reod.reod_client.types import Response

    response: Response[ListUserContextResponse200] = list_user_context.sync_detailed(client=client, size=2)
    if response.status_code != 200:
        print("Error: " + response.content.decode("utf-8"))
        exit (1)

    content = response.parsed
    print(f"Received {content.meta.total_pages} pages")
    print(f"Found {content.meta.total_count} user contexts:")

    results = content.data
    while content.meta.next_page_token:
        print(f"Page token: {content.meta.next_page_token}")
        response: Response[ListUserContextResponse200] = list_user_context.sync_detailed(client=client, page_token=content.meta.next_page_token)
        if response.status_code != 200:
            print("Error: " + response.content.decode("utf-8"))
            exit (1)
        content = response.parsed
        results += content.data

    ctx: UserContext
    for ctx in results:
        print(ctx)
