import os

from dotenv import load_dotenv

from energyclass.energy_class_client import AuthenticatedClient

load_dotenv()

from client_credentials_client import client_credentials_flow

BASE_URL = os.getenv('BASE_URL')

auth_response = client_credentials_flow()

with AuthenticatedClient(
        base_url=BASE_URL,
        token=auth_response.access_token
) as client:
    from energyclass.energy_class_client.api.default import get_api_products_v1_energyclass_egid
    from energyclass.energy_class_client.models import EnergyClass
    from energyclass.energy_class_client.types import Response

    response: Response[EnergyClass] = get_api_products_v1_energyclass_egid.sync_detailed(client=client, egid=504081857)
    if response.status_code != 200:
        print("Error: " + response.content.decode("utf-8"))
        exit (1)

    energyclass = response.parsed

    print(f"Energyclass: {energyclass}")

