import os
from dotenv import load_dotenv
load_dotenv()

from authorization_code_client import authorization_code_flow

BASE_URL = os.getenv('BASE_URL')

auth_response = authorization_code_flow()

from reod.reod_client import AuthenticatedClient

ctx_external_ref = '0ac33437-96fd-419d-871c-50c92f40fbb6'

with AuthenticatedClient(
        base_url=BASE_URL,
        token=auth_response.access_token
) as client:
    from reod.reod_client.models import UserContext, AbstractUserContext
    from reod.reod_client.api.user_context import create_user_context
    from reod.reod_client.types import Response


    abstract_user_context = AbstractUserContext(name="example_context", origin="dev_guide", external_ref=ctx_external_ref,
                                                description="User Context created from Dev Guide example")

    print(f"Creating User Context: {str(abstract_user_context)}")

    response: Response[UserContext] = create_user_context.sync_detailed(client=client, body=abstract_user_context)
    if response.status_code != 200:
        print("Error: " + response.content.decode("utf-8"))
        exit (1)

    print(f"Created User Context: {str(response.parsed)}")
