from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.pagination_metadata import PaginationMetadata


T = TypeVar("T", bound="PaginationBody")


@_attrs_define
class PaginationBody:
    """
    Attributes:
        meta (PaginationMetadata):
        data (list[Any]):
    """

    meta: "PaginationMetadata"
    data: list[Any]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        meta = self.meta.to_dict()

        data = self.data

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "meta": meta,
                "data": data,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.pagination_metadata import PaginationMetadata

        d = dict(src_dict)
        meta = PaginationMetadata.from_dict(d.pop("meta"))

        data = cast(list[Any], d.pop("data"))

        pagination_body = cls(
            meta=meta,
            data=data,
        )

        pagination_body.additional_properties = d
        return pagination_body

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
