from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.energy_class_data_provider import EnergyClassDataProvider
from ..types import UNSET, Unset

T = TypeVar("T", bound="EnergyClassRequest")


@_attrs_define
class EnergyClassRequest:
    """
    Attributes:
        egids (list[int]):  Example: [299033, 504081857, 1754854, 321146].
        data_provider (Union[Unset, EnergyClassDataProvider]):  Default: EnergyClassDataProvider.REMMS.
    """

    egids: list[int]
    data_provider: Union[Unset, EnergyClassDataProvider] = EnergyClassDataProvider.REMMS
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        egids = self.egids

        data_provider: Union[Unset, str] = UNSET
        if not isinstance(self.data_provider, Unset):
            data_provider = self.data_provider.value

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "egids": egids,
            }
        )
        if data_provider is not UNSET:
            field_dict["dataProvider"] = data_provider

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        egids = cast(list[int], d.pop("egids"))

        _data_provider = d.pop("dataProvider", UNSET)
        data_provider: Union[Unset, EnergyClassDataProvider]
        if isinstance(_data_provider, Unset):
            data_provider = UNSET
        else:
            data_provider = EnergyClassDataProvider(_data_provider)

        energy_class_request = cls(
            egids=egids,
            data_provider=data_provider,
        )

        energy_class_request.additional_properties = d
        return energy_class_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
