from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.certificates import Certificates
    from ..models.energy_kpi import EnergyKpi


T = TypeVar("T", bound="EnergyClassInformation")


@_attrs_define
class EnergyClassInformation:
    """
    Attributes:
        certificates (Union[Unset, Certificates]):
        energy_kpi (Union[Unset, EnergyKpi]):
    """

    certificates: Union[Unset, "Certificates"] = UNSET
    energy_kpi: Union[Unset, "EnergyKpi"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        certificates: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.certificates, Unset):
            certificates = self.certificates.to_dict()

        energy_kpi: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.energy_kpi, Unset):
            energy_kpi = self.energy_kpi.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if certificates is not UNSET:
            field_dict["certificates"] = certificates
        if energy_kpi is not UNSET:
            field_dict["energyKpi"] = energy_kpi

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.certificates import Certificates
        from ..models.energy_kpi import EnergyKpi

        d = dict(src_dict)
        _certificates = d.pop("certificates", UNSET)
        certificates: Union[Unset, Certificates]
        if isinstance(_certificates, Unset):
            certificates = UNSET
        else:
            certificates = Certificates.from_dict(_certificates)

        _energy_kpi = d.pop("energyKpi", UNSET)
        energy_kpi: Union[Unset, EnergyKpi]
        if isinstance(_energy_kpi, Unset):
            energy_kpi = UNSET
        else:
            energy_kpi = EnergyKpi.from_dict(_energy_kpi)

        energy_class_information = cls(
            certificates=certificates,
            energy_kpi=energy_kpi,
        )

        energy_class_information.additional_properties = d
        return energy_class_information

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
