from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.building_identification_item import BuildingIdentificationItem
    from ..models.energy_class_information import EnergyClassInformation


T = TypeVar("T", bound="EnergyClass")


@_attrs_define
class EnergyClass:
    """
    Attributes:
        egid (Union[None, Unset, int]):
        egrid (Union[None, Unset, str]):
        building_identification (Union[None, Unset, list['BuildingIdentificationItem']]):
        energy_class_information (Union[Unset, EnergyClassInformation]):
    """

    egid: Union[None, Unset, int] = UNSET
    egrid: Union[None, Unset, str] = UNSET
    building_identification: Union[None, Unset, list["BuildingIdentificationItem"]] = UNSET
    energy_class_information: Union[Unset, "EnergyClassInformation"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        egid: Union[None, Unset, int]
        if isinstance(self.egid, Unset):
            egid = UNSET
        else:
            egid = self.egid

        egrid: Union[None, Unset, str]
        if isinstance(self.egrid, Unset):
            egrid = UNSET
        else:
            egrid = self.egrid

        building_identification: Union[None, Unset, list[dict[str, Any]]]
        if isinstance(self.building_identification, Unset):
            building_identification = UNSET
        elif isinstance(self.building_identification, list):
            building_identification = []
            for building_identification_type_0_item_data in self.building_identification:
                building_identification_type_0_item = building_identification_type_0_item_data.to_dict()
                building_identification.append(building_identification_type_0_item)

        else:
            building_identification = self.building_identification

        energy_class_information: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.energy_class_information, Unset):
            energy_class_information = self.energy_class_information.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if egid is not UNSET:
            field_dict["egid"] = egid
        if egrid is not UNSET:
            field_dict["egrid"] = egrid
        if building_identification is not UNSET:
            field_dict["buildingIdentification"] = building_identification
        if energy_class_information is not UNSET:
            field_dict["energyClassInformation"] = energy_class_information

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.building_identification_item import BuildingIdentificationItem
        from ..models.energy_class_information import EnergyClassInformation

        d = dict(src_dict)

        def _parse_egid(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        egid = _parse_egid(d.pop("egid", UNSET))

        def _parse_egrid(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        egrid = _parse_egrid(d.pop("egrid", UNSET))

        def _parse_building_identification(data: object) -> Union[None, Unset, list["BuildingIdentificationItem"]]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                building_identification_type_0 = []
                _building_identification_type_0 = data
                for building_identification_type_0_item_data in _building_identification_type_0:
                    building_identification_type_0_item = BuildingIdentificationItem.from_dict(
                        building_identification_type_0_item_data
                    )

                    building_identification_type_0.append(building_identification_type_0_item)

                return building_identification_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, list["BuildingIdentificationItem"]], data)

        building_identification = _parse_building_identification(d.pop("buildingIdentification", UNSET))

        _energy_class_information = d.pop("energyClassInformation", UNSET)
        energy_class_information: Union[Unset, EnergyClassInformation]
        if isinstance(_energy_class_information, Unset):
            energy_class_information = UNSET
        else:
            energy_class_information = EnergyClassInformation.from_dict(_energy_class_information)

        energy_class = cls(
            egid=egid,
            egrid=egrid,
            building_identification=building_identification,
            energy_class_information=energy_class_information,
        )

        energy_class.additional_properties = d
        return energy_class

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
