from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.energy_class_request import EnergyClassRequest
from ...models.pagination_body_energy_class import PaginationBodyEnergyClass
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    body: EnergyClassRequest,
    page_token: Union[None, Unset, str] = UNSET,
    size: Union[None, Unset, int] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}
    if not isinstance(user_language, Unset):
        headers["User-Language"] = user_language

    params: dict[str, Any] = {}

    json_page_token: Union[None, Unset, str]
    if isinstance(page_token, Unset):
        json_page_token = UNSET
    else:
        json_page_token = page_token
    params["pageToken"] = json_page_token

    json_size: Union[None, Unset, int]
    if isinstance(size, Unset):
        json_size = UNSET
    else:
        json_size = size
    params["size"] = json_size

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": "/api-products/v1/energyclass",
        "params": params,
    }

    _body = body.to_dict()

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[PaginationBodyEnergyClass]:
    if response.status_code == 200:
        response_200 = PaginationBodyEnergyClass.from_dict(response.json())

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[PaginationBodyEnergyClass]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyClassRequest,
    page_token: Union[None, Unset, str] = UNSET,
    size: Union[None, Unset, int] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Response[PaginationBodyEnergyClass]:
    """
    Args:
        page_token (Union[None, Unset, str]):
        size (Union[None, Unset, int]):
        user_language (Union[Unset, str]):  Example: deu.
        body (EnergyClassRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[PaginationBodyEnergyClass]
    """

    kwargs = _get_kwargs(
        body=body,
        page_token=page_token,
        size=size,
        user_language=user_language,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyClassRequest,
    page_token: Union[None, Unset, str] = UNSET,
    size: Union[None, Unset, int] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[PaginationBodyEnergyClass]:
    """
    Args:
        page_token (Union[None, Unset, str]):
        size (Union[None, Unset, int]):
        user_language (Union[Unset, str]):  Example: deu.
        body (EnergyClassRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        PaginationBodyEnergyClass
    """

    return sync_detailed(
        client=client,
        body=body,
        page_token=page_token,
        size=size,
        user_language=user_language,
    ).parsed


async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyClassRequest,
    page_token: Union[None, Unset, str] = UNSET,
    size: Union[None, Unset, int] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Response[PaginationBodyEnergyClass]:
    """
    Args:
        page_token (Union[None, Unset, str]):
        size (Union[None, Unset, int]):
        user_language (Union[Unset, str]):  Example: deu.
        body (EnergyClassRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[PaginationBodyEnergyClass]
    """

    kwargs = _get_kwargs(
        body=body,
        page_token=page_token,
        size=size,
        user_language=user_language,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    body: EnergyClassRequest,
    page_token: Union[None, Unset, str] = UNSET,
    size: Union[None, Unset, int] = UNSET,
    user_language: Union[Unset, str] = UNSET,
) -> Optional[PaginationBodyEnergyClass]:
    """
    Args:
        page_token (Union[None, Unset, str]):
        size (Union[None, Unset, int]):
        user_language (Union[Unset, str]):  Example: deu.
        body (EnergyClassRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        PaginationBodyEnergyClass
    """

    return (
        await asyncio_detailed(
            client=client,
            body=body,
            page_token=page_token,
            size=size,
            user_language=user_language,
        )
    ).parsed
